/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.robo_entity.states;

import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntity;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntityState;
import de.theidler.create_mobile_packages.entities.robo_entity.states.LaunchFinishState;
import net.minecraft.world.phys.Vec3;

public class LaunchAscendState
implements RoboEntityState {
    private float initialDistanceToTarget = 0.0f;

    @Override
    public void tick(RoboEntity re) {
        BeePortBlockEntity bpbe = re.getStartBeePortBlockEntity();
        if (bpbe == null) {
            re.setState(new LaunchFinishState());
            return;
        }
        Vec3 target = bpbe.getBlockPos().getCenter().add(0.0, 2.0, 0.0);
        Vec3 direction = target.subtract(re.position()).normalize();
        re.setTargetVelocity(direction.scale(0.05));
        double distanceToTarget = re.position().distanceToSqr(target);
        if (this.initialDistanceToTarget == 0.0f) {
            this.initialDistanceToTarget = (float)distanceToTarget;
        }
        if (distanceToTarget < 0.2) {
            re.setPackageHeightScale(1.0f);
            re.setState(new LaunchFinishState());
        } else {
            float scale = 1.0f - (float)(distanceToTarget / (double)this.initialDistanceToTarget);
            re.setPackageHeightScale(scale);
        }
    }
}

